/*{
	"GUID":"A5394086-2AE7-4df3-B85B-0D69E4594338"
}*/

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;
#define vec2 float2
#define vec3 float3
#define vec4 float4
#define PI 3.141592626535f
static vec2 myMod(vec2 x, float y)
{
	return x-y * floor (x/y);
}


static vec2 mirror(vec2 uv)
{
	vec2 parity = myMod(floor(uv),2.0f);
	vec2 sign = -2.0f*parity + 1.0f;
	return myMod( 2.0f*parity+sign*myMod(uv,1.0f),1.0f);
}

vec4 INPUT(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, mirror(tc));
}

__constant vec2 MidTop = (vec2)(0.50000f,0.88333f);
__constant vec2 LeftBottom = (vec2)(0.15625f,0.08333f);
__constant vec2 RightBottom = (vec2)(0.84375f,0.08333f);

float Degree2Arc(float d)
{
 	return d * PI / 180.f;
}
// auchor: RSQ
// data:   2017/6/30


__kernel void MAIN(__read_only image2d_t input1,__write_only image2d_t dest_data, __global FilterParam* param, int alpha)
{
	float iGlobalTime = param->cur_time / param->total_time;
	
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[0];
	
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 iResolution = (float2)(W,H);
	int2 fragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 gl_FragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 tc = (vec2)(gl_FragCoord.x + 0.5f, gl_FragCoord.y + 0.5f )/iResolution.xy;
	
	tc = (vec2)(tc.x, 1.0f - tc.y);
	
	vec2 uv = (vec2)(gl_FragCoord.x,gl_FragCoord.y);
    float i =  H - gl_FragCoord.y;
    float j = gl_FragCoord.x;
	
    float tan30 = tan(30.f * PI / 180.f);
    vec2 aMidTop = (vec2)(MidTop.x*iResolution.x, MidTop.y*iResolution.y);
	vec2 aLeftBottom = (vec2)(LeftBottom.x*iResolution.x, LeftBottom.y*iResolution.y);
	vec2 aRightBottom = (vec2)(RightBottom.x*iResolution.x, RightBottom.y*iResolution.y);
	aLeftBottom.x = aMidTop.x - (aMidTop.y - aLeftBottom.y) * tan30;
	aRightBottom.x = aMidTop.x + (aMidTop.y - aLeftBottom.y) * tan30;

	float angleTopMid = atan2((float)(i - aMidTop.y), (float)(j - aMidTop.x));
	float angleBottomLeft = atan2((float)(i - aLeftBottom.y), (float)(j - aLeftBottom.x));
	float angleBottomRight = atan2((float)(i - aRightBottom.y), (float)(j - aRightBottom.x));
			//Mid Triangle
	if (i <= aMidTop.y  && 
		angleBottomLeft > Degree2Arc(60.f) && angleBottomLeft <= Degree2Arc(120.f))	//Left Triangle
	{
		float nDistance = sqrt((float)(i - aMidTop.y) * (i - aMidTop.y) + (j - aMidTop.x) * (j - aMidTop.x));
		uv.x = aMidTop.x + nDistance * cos(angleTopMid + 60.f * PI / 180.f);
		uv.y = aMidTop.y + nDistance * sin(angleTopMid + 60.f * PI / 180.f);
	}
	else if (i <= aMidTop.y &&
		angleBottomRight > Degree2Arc(60.f) && angleBottomRight <= Degree2Arc(120.f))	//Right Triangle
	{
		float nDistance = sqrt((float)(i - aMidTop.y) * (i - aMidTop.y) + (j - aMidTop.x) * (j - aMidTop.x));
		uv.x = aMidTop.x + nDistance * cos(angleTopMid - 60.f * PI / 180.f);
		uv.y = aMidTop.y + nDistance * sin(angleTopMid - 60.f* PI / 180.f);
	}
	else if (angleTopMid >= Degree2Arc(0.f) && angleTopMid < Degree2Arc(60.f))
	{
		float nDistance = sqrt((float)(i - aMidTop.y) * (i - aMidTop.y) + (j - aMidTop.x) * (j - aMidTop.x));
		uv.x = aMidTop.x + nDistance * cos(angleTopMid - 120.f * PI / 180.f);
		uv.y = aMidTop.y + nDistance * sin(angleTopMid - 120.f * PI / 180.f);
	}
	else if (angleTopMid >= Degree2Arc(60.f) && angleTopMid < Degree2Arc(120.f))
	{
		float nDistance = sqrt((float)(i - aMidTop.y) * (i - aMidTop.y) + (j - aMidTop.x) * (j - aMidTop.x));
		uv.x = aMidTop.x + nDistance * cos(angleTopMid + 180.f * PI / 180.f);
		uv.y = aMidTop.y + nDistance * sin(angleTopMid + 180.f * PI / 180.f);
	}
	else if (angleTopMid >= Degree2Arc(120.f) && angleTopMid < Degree2Arc(180.f))
	{
		float nDistance = sqrt((float)(i - aMidTop.y) * (i - aMidTop.y) + (j - aMidTop.x) * (j - aMidTop.x));
		uv.x = aMidTop.x + nDistance * cos(angleTopMid + 120.f * PI / 180.f);
		uv.y = aMidTop.y + nDistance * sin(angleTopMid + 120.f * PI / 180.f);
	}

	else if (angleBottomRight >= Degree2Arc(0.f) && angleBottomRight < Degree2Arc(60.f))
	{
		float nDistance = sqrt((float)(i - aRightBottom.y) * (i - aRightBottom.y) + (j - aRightBottom.x) * (j - aRightBottom.x));
		uv.x = aRightBottom.x + nDistance * cos(angleBottomRight + 120.f * PI / 180.f);
		uv.y = aRightBottom.y + nDistance * sin(angleBottomRight + 120.f * PI / 180.f);
	}
	else if (angleBottomRight >= Degree2Arc(-60.f) && angleBottomRight < Degree2Arc(0.f))
	{
		float nDistance = sqrt((float)(i - aRightBottom.y) * (i - aRightBottom.y) + (j - aRightBottom.x) * (j - aRightBottom.x));
		uv.x = aRightBottom.x + nDistance * cos(-angleBottomRight + 120.f * PI / 180.f);
		uv.y = aRightBottom.y + nDistance * sin(-angleBottomRight + 120.f * PI / 180.f);
		
	}
	else if (angleBottomRight >= Degree2Arc(-120.f) && angleBottomRight < Degree2Arc(-60.f))
	{
		float nDistance = sqrt((float)(i - aRightBottom.y) * (i - aRightBottom.y) + (j - aRightBottom.x) * (j - aRightBottom.x));
		uv.x = aLeftBottom.x + nDistance * cos(angleBottomRight + 120.f * PI / 180.f);	//aLeftBottom to make it looks like mirror
		uv.y = aLeftBottom.y + nDistance * sin(angleBottomRight + 120.f * PI / 180.f);
	}
	else if (angleBottomRight >= Degree2Arc(-180.f) && angleBottomRight < Degree2Arc(-120.f) &&
			angleBottomLeft >= Degree2Arc(-60.f) && angleBottomLeft < Degree2Arc(0.f)
		)
	{
		uv.x = uv.x*i;
		uv.y = 2.f* aRightBottom.y - i;
		
	}
	else if (angleBottomLeft >= Degree2Arc(-120.f) && angleBottomLeft < Degree2Arc(-60.f)
		)
	{
		float nDistance = sqrt((float)(i - aLeftBottom.y) * (i - aLeftBottom.y) + (j - aLeftBottom.x) * (j - aLeftBottom.x));
		uv.x = aRightBottom.x + nDistance * cos(angleBottomLeft - 120.f * PI / 180.f);
		uv.y = aRightBottom.y + nDistance * sin(angleBottomLeft - 120.f * PI / 180.f);
	}
	else if (angleBottomLeft > Degree2Arc(-180.f) && angleBottomLeft < Degree2Arc(-120.f))
	{
		float nDistance = sqrt((float)(i - aLeftBottom.y) * (i - aLeftBottom.y) + (j - aLeftBottom.x) * (j - aLeftBottom.x));
		uv.x = aLeftBottom.x + nDistance * cos(-angleBottomLeft - 120.f * PI / 180.f);
		uv.y = aLeftBottom.y + nDistance * sin(-angleBottomLeft - 120.f * PI / 180.f);
		
	}
	else if (angleBottomLeft > Degree2Arc(120.f) && angleBottomLeft <= Degree2Arc(181.f) )
	{
		float nDistance = sqrt((float)(i - aLeftBottom.y) * (i - aLeftBottom.y) + (j - aLeftBottom.x) * (j - aLeftBottom.x));
		uv.x = aLeftBottom.x + nDistance * cos(angleBottomLeft - 120.f * PI / 180.f);
		uv.y = aLeftBottom.y + nDistance * sin(angleBottomLeft - 120.f * PI / 180.f);
		
	}else
	{
		uv = (vec2)(uv.x, H - uv.y);
	}
	
	uv = (vec2)(uv.x,uv.y)/iResolution.xy;
	
	vec4 outCol = INPUT(input1, param, (vec2)(uv.x, 1.0f - uv.y));	
	vec4 origCol = INPUT(input1, param, tc);
	outCol = outCol * alpha/100.0f + origCol *(1.0f - alpha/100.0f);
	write_imagef(dest_data, (int2)(fragCoord.x, fragCoord.y), outCol); 
}
